#!/bin/bash
#SBATCH --nodes=1
#SBATCH --gres=gpu:1
#SBATCH --ntasks-per-node=1
#SBATCH --partition=gpu
#SBATCH --cpus-per-task=9
#SBATCH --job-name=IN1k-LP
#SBATCH --time=96:00:00
#SBATCH --mem=120G
#SBATCH --constraint=v100|rtx6k|rtx8k|p40|v100s
#SBATCH --exclude=gnodee8,gnodec1



#DATASET_PATH='/scratch/local/ssd/datasets/Imagenet'
tar xf /scratch/shared/beegfs/yuki/data/ILSVRC12.tar -C ${TMPDIR}
DATASET_PATH=${TMPDIR}/ILSVRC12

EXP_STR=$1

EXPERIMENT_PATH="/scratch/shared/beegfs/yuki/adiwol/experiments/yuki/${EXP_STR}"
MODEL_STR=${EXPERIMENT_PATH}/checkpoint.pth.tar
EXPERIMENT_PATH+='/LP'
mkdir -p $EXPERIMENT_PATH
echo "will use" ${MODEL_STR}

CUDA_VISIBLE_DEVICES=0 /scratch/shared/beegfs/yuki/envs/py37/bin/python3 main_lincls.py \
            -a resnet50 \
            --lr 30.0 \
            --batch-size 256 \
            --pretrained ${MODEL_STR} \
            --resume ${EXPERIMENT_PATH}/checkpoint.pth.tar \
            --dump_path ${EXPERIMENT_PATH} \
            ${DATASET_PATH} 2>&1 | tee -a ${EXPERIMENT_PATH}/log.txt
